<?php
    /**
    *
    * copyright (c) 2013-2022 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    *
    */

    include "../../include/includeBaseControllerComponenti.php";
    include "../classi/Form.php";
    
    if(isset($_POST["operazione"])) {
        $operazione = filter_input(INPUT_POST,"operazione",FILTER_SANITIZE_STRING);
        $form = new Form($geecomDb, filter_input(INPUT_POST, "id"));
    }
    else {
        $operazione = filter_input(INPUT_GET,"operazione",FILTER_SANITIZE_STRING);
        $form = new Form($geecomDb, filter_input(INPUT_GET, "id"));
    }
    
    switch ($operazione) {
        case 'crea':
            $usaAjax     = (isset($_POST["usaAjax"]) && $_POST["usaAjax"]=="si") ? "si" : "no";
            $formInLinea = (isset($_POST["formInLinea"]) && $_POST["formInLinea"]=="si") ? "si" : "no";
            $mostraTitoloComponente = (isset($_POST["mostraTitoloComponente"]) && $_POST["mostraTitoloComponente"]=="si") ? "si" : "no";
            
            $form->setNome(filter_input(INPUT_POST,"nome",FILTER_SANITIZE_ADD_SLASHES));
            $form->setTesto(filter_input(INPUT_POST,"testo",FILTER_SANITIZE_ADD_SLASHES));
            $form->setSpazioOccupato(filter_input(INPUT_POST,"spazioOccupato",FILTER_SANITIZE_STRING));
            $form->setOggettoNotificaAmministratore("Nuovo messaggio dal tuo sito {$impostazioni["titoloSito"]}");
            $form->setFormInLinea($formInLinea);
            $form->setLinkPrivacy(filter_input(INPUT_POST,"linkPrivacy",FILTER_SANITIZE_STRING));
            $form->setSpuntaPrivacy(filter_input(INPUT_POST,"spuntaPrivacy",FILTER_SANITIZE_STRING));
            $form->setAzione(filter_input(INPUT_POST,"azione",FILTER_SANITIZE_STRING));
            $form->setEtichettaPulsante(filter_input(INPUT_POST,"etichettaPulsante",FILTER_SANITIZE_STRING));
            $form->setIconaPulsante(filter_input(INPUT_POST,"iconaPulsante",FILTER_SANITIZE_STRING));
            $form->setSpazioOccupatoPulsante(filter_input(INPUT_POST,"spazioOccupatoPulsante",FILTER_SANITIZE_STRING));
            $form->setStampaLinkPaginaForm(filter_input(INPUT_POST,"stampaLinkPaginaForm",FILTER_SANITIZE_STRING));
            $form->setLinkScriptEsterno(filter_input(INPUT_POST,"linkScriptEsterno",FILTER_SANITIZE_STRING));
            $form->setLinkScriptRicerca(filter_input(INPUT_POST,"linkScriptRicerca",FILTER_SANITIZE_STRING));
            $form->setusaAjax($usaAjax);
            $form->setNoteAggiuntive(filter_input(INPUT_POST,"noteAggiuntive",FILTER_SANITIZE_STRING));
            $form->setMostraTitoloComponente($mostraTitoloComponente);
            $form->crea();
            header("Location: ../creaForm.php?id={$form->getId()}&status=200");
            break;
        case 'aggiornaDatiPrincipali':
            $usaAjax     = (isset($_POST["usaAjax"]) && $_POST["usaAjax"]=="si") ? "si" : "no";
            $formInLinea = (isset($_POST["formInLinea"]) && $_POST["formInLinea"]=="si") ? "si" : "no";
            $mostraTitoloComponente = (isset($_POST["mostraTitoloComponente"]) && $_POST["mostraTitoloComponente"]=="si") ? "si" : "no";
            
            $form->setNome(filter_input(INPUT_POST,"nome",FILTER_SANITIZE_ADD_SLASHES));
            $form->setTesto(filter_input(INPUT_POST,"testo",FILTER_SANITIZE_ADD_SLASHES));
            $form->setSpazioOccupato(filter_input(INPUT_POST,"spazioOccupato",FILTER_SANITIZE_STRING));
            $form->setFormInLinea($formInLinea);
            $form->setLinkPrivacy(filter_input(INPUT_POST,"linkPrivacy",FILTER_SANITIZE_STRING));
            $form->setSpuntaPrivacy(filter_input(INPUT_POST,"spuntaPrivacy",FILTER_SANITIZE_STRING));
            $form->setAzione(filter_input(INPUT_POST,"azione",FILTER_SANITIZE_STRING));
            $form->setEtichettaPulsante(filter_input(INPUT_POST,"etichettaPulsante",FILTER_SANITIZE_STRING));
            $form->setIconaPulsante(filter_input(INPUT_POST,"iconaPulsante",FILTER_SANITIZE_STRING));
            $form->setSpazioOccupatoPulsante(filter_input(INPUT_POST,"spazioOccupatoPulsante",FILTER_SANITIZE_STRING));
            $form->setLinkScriptEsterno(filter_input(INPUT_POST,"linkScriptEsterno",FILTER_SANITIZE_STRING));
            $form->setLinkScriptRicerca(filter_input(INPUT_POST,"linkScriptRicerca",FILTER_SANITIZE_STRING));
            $form->setTipoConfermaMessaggioInviato("Messaggio a video");
            $form->setTestoMessaggioInviato("Grazie! Ti contatteremo quanto prima");
            $form->setusaAjax($usaAjax);
            $form->setNoteAggiuntive(filter_input(INPUT_POST,"noteAggiuntive",FILTER_SANITIZE_STRING));
            $form->setMostraTitoloComponente($mostraTitoloComponente);
            $form->modificaInformazioniPrincipali();
            header("Location: ../creaForm.php?id={$form->getId()}&status=250");
            break;
        case 'aggiornaDatiConferme':
            $form->setTipoConfermaMessaggioInviato(filter_input(INPUT_POST,"tipoConfermaMessaggioInviato",FILTER_SANITIZE_STRING));
            $form->setTestoMessaggioInviato(filter_input(INPUT_POST,"testoMessaggioInviato",FILTER_SANITIZE_STRING));
            $form->setTestoMessaggioErrore(filter_input(INPUT_POST,"testoMessaggioErrore",FILTER_SANITIZE_STRING));
            $form->setPaginaRingraziamento(filter_input(INPUT_POST,"paginaRingraziamento",FILTER_SANITIZE_NUMBER_INT));
            
            $form->modificaDatiConferme();
            header("Location: ../creaForm.php?id={$form->getId()}&status=251");
            break;
        case 'aggiornaDatiNotifiche':
            $attivaNotificaUtente = (isset($_POST["attivaNotificaUtente"]) && $_POST["attivaNotificaUtente"]=="si") ? "si" : "no";
            
            $form->setEmailNotificaAmministratore(filter_input(INPUT_POST,"emailNotificaAmministratore",FILTER_SANITIZE_STRING));
            $form->setRispondiA(filter_input(INPUT_POST,"rispondiA",FILTER_SANITIZE_STRING));
            $form->setOggettoNotificaAmministratore(filter_input(INPUT_POST,"oggettoNotificaAmministratore",FILTER_SANITIZE_STRING));
            $form->setStampaLinkPaginaForm(filter_input(INPUT_POST,"stampaLinkPaginaForm",FILTER_SANITIZE_STRING));
            $form->setAttivaNotificaUtente($attivaNotificaUtente);
            $form->setCampoEmailNotificaUtente(filter_input(INPUT_POST,"campoEmailNotificaUtente",FILTER_SANITIZE_STRING));
            $form->setNomeMittenteNotificaUtente(filter_input(INPUT_POST,"nomeMittenteNotificaUtente",FILTER_SANITIZE_STRING));
            $form->setEmailMittenteNotificaUtente(filter_input(INPUT_POST,"emailMittenteNotificaUtente",FILTER_SANITIZE_STRING));
            $form->setOggettoNotificaUtente(filter_input(INPUT_POST,"oggettoNotificaUtente",FILTER_SANITIZE_STRING));
            $form->setTemplateEmailNotificaUtente(filter_input(INPUT_POST,"templateEmailNotificaUtente",FILTER_SANITIZE_STRING));
            $form->modificaDatiNotifiche();
            header("Location: ../creaForm.php?id={$form->getId()}&status=252");
            break;
        case 'elimina':
            $form->elimina();
            echo "ok";
            break;
        case 'eliminaMessaggio':
            $idMessaggio = filter_input(INPUT_POST,"idMessaggio",FILTER_SANITIZE_NUMBER_INT);
            $form->eliminaMessaggio($idMessaggio);
            echo "ok";
            break;
        case 'duplica':
            $form->caricaDatiDalDatabase();
            $idNuovaForm = $form->duplica();
            header("Location: ../creaForm.php?id={$idNuovaForm}&status=260");
            break;
        case 'duplicaElemento':
            $idNuovoElemento = $form->duplicaElemento(filter_input(INPUT_GET, "idElemento",FILTER_SANITIZE_NUMBER_INT));
            header("Location: ../creaElemento.php?id={$idNuovoElemento}&status=210");
            break;
        case 'stampaElementi':
            $tipiCampo = array(
                "Testo"    =>"template/img/componenti/inputForm/icon_input_text.svg",
                "Email"    =>"template/img/componenti/inputForm/icon_input_email.svg",
                "Tendina"  =>"template/img/componenti/inputForm/icon_input_select.svg",
                "Area testo" =>"template/img/componenti/inputForm/icon_input_textarea.svg",
                "Data"       =>"template/img/componenti/inputForm/icon_input_data.svg",
                "Orario"     =>"template/img/componenti/inputForm/icon_input_ora.svg",
                "Checkbox"   =>"template/img/componenti/inputForm/icon_input_checkbox.svg");
            
            $form->stampaElementi($tipiCampo);
            break;
        case 'creaElemento':
            $tipo   = filter_input(INPUT_POST, "tipo",FILTER_SANITIZE_STRING);
            $form->creaElemento($tipo,"col-12");
            echo "ok";
            break;
        case 'spostaElemento':
            $form->spostaElemento(filter_input(INPUT_POST, "idElemento",FILTER_SANITIZE_NUMBER_INT),filter_input(INPUT_POST, "posizione",FILTER_SANITIZE_NUMBER_INT));
            echo "ok";
            break;
        case 'modificaElemento':
            $idElemento     = filter_input(INPUT_POST,"idElemento",FILTER_SANITIZE_STRING);
            $etichetta      = filter_input(INPUT_POST,"etichetta",FILTER_SANITIZE_STRING);
            $spazioOccupato = filter_input(INPUT_POST,"spazioOccupato",FILTER_SANITIZE_STRING);
            $nome           = filter_input(INPUT_POST,"nome",FILTER_SANITIZE_ADD_SLASHES);
            $valore         = filter_input(INPUT_POST,"valore",FILTER_SANITIZE_STRING);
            $placeholder    = filter_input(INPUT_POST,"placeholder",FILTER_SANITIZE_STRING);
            $tipo           = filter_input(INPUT_POST,"tipo",FILTER_SANITIZE_STRING);
            $opzioni        = filter_input(INPUT_POST,"opzioni",FILTER_SANITIZE_STRING);
            $obbligatorio   = (isset($_POST["obbligatorio"]) && $_POST["obbligatorio"]=="si") ? "si" : "no";
            $form->modificaElemento($idElemento,$etichetta, $spazioOccupato, $nome, $valore, $placeholder,$tipo,$opzioni,$obbligatorio);
            header("Location: ../creaElemento.php?id={$idElemento}&status=200");
            break;
        case 'modificaRapidaElemento':
            $idElemento   = filter_input(INPUT_POST,'idElemento',FILTER_SANITIZE_NUMBER_INT);
            $nome 	  = filter_input(INPUT_POST,'nome',FILTER_SANITIZE_STRING);
            $etichetta    = filter_input(INPUT_POST,'etichetta',FILTER_SANITIZE_STRING);
            $valore       = filter_input(INPUT_POST,'valore',FILTER_SANITIZE_STRING);

            $form->modificaRapidaElemento($idElemento,$etichetta,$nome,$valore);
            echo "ok";
            break;
        case 'eliminaElemento':
            $form->eliminaElemento(filter_input(INPUT_POST, "idElemento",FILTER_SANITIZE_NUMBER_INT));
            echo "ok";
            break;
    }